/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#ifndef _DESCRIPTORMANAGER_H_
#define _DESCRIPTORMANAGER_H_

using namespace std;
#include <map>
#include "Conf.h"
#include "U4ADefines.h"
#include "Log.h"
#include "iDescriptorLayer.h"
#include "iDriverLayer.h"

typedef struct {
    int dsc;
    int tin;
    int buffer;
    int cantAsignados;
} itemIn;

typedef struct {
    int dsc;
    int tout;
    int buffer;
    int cantAsignados;
} itemOut;

class DescriptorManager : public iDescriptorLayer {
    private:
        iDriverLayer *dl;
        log *l;
        multimap<int,itemIn> dscIn;
        multimap<int,itemOut> dscOut;
        map<int,int> serials;
        int getBufferIn(int, int);
        int getBufferOut(int, int);
        int getTypeDscIn(int, int);
        int getTypeDscOut(int, int);
    public:
        DescriptorManager();
        ~DescriptorManager();
        bool send(int, int, char *, int, int);
        char* receive(int, int, int&, bool&, int);
        int* getU4ABoards(int&);
        int requestDscIn(int, int);
        int requestDscOut(int, int);
        void freeDscIn(int, int);
        void freeDscOut(int, int);
        int getInstanceBoard(int);
};

#endif
